//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

/*!
\qmltype     UiLabel
\inqmlmodule we.captivo.Ui
\since       we.captivo.Ui 1.0
\inherits    QtQuick2::Text
\ingroup     captivo-ui-controls

\brief A styled control label element.

The UiLabel component provides a pre-styled text item for use as a
control label.

The following example shows the use of this component:

\qml
import QtQuick 2.4

import wesual.Ui 1.0

Row {
    spacing : 10

    UiLabel {
        text : "Visibility"
    }
    UiCheckBox {
        text : "visible"
    }
}
\endqml
*/

Text {
    id : uiLabel

    font  : UiFonts.getFont(UiFonts.RegularCapitalized, 11)
    color : UiColors.getColor(UiColors.MediumGrey33)
    elide : Text.ElideRight

    states : State {
        name : "disabled"
        when : !uiLabel.enabled

        PropertyChanges {
            target: uiLabel
            color  : UiColors.getColor(UiColors.MediumLightGrey27)
        }
    }
}
